TITLE   'Permanent Magnet, Thin Coil' 			         { exa137.pde }
SELECT     					{ Professional Edition }
   errlim=1e-4     ngrid=1     spectral_colors	
COORDINATES   ycylinder( 'r', 'z')
VARIABLES   A_phi
DEFINITIONS
   L=1.0     d=1e-3    r1=0.1-d/2     r2=0.1+d/2    rm=(r1+r2)/2     Lz=0.1
   mu0=4*pi*1e-7     mu=mu0     J_phi
   Br=-dz(A_phi)     Bz=1/r*dr(r*A_phi)
   B=vector( Br, Bz)     Bm=magnitude( B)
   Hr=Br/mu     Hz=Bz/mu     H=B/mu     Hm=Bm/mu
   Mz00=1e5     z1=z+Lz   Bz_ex=		{ Exact solution on the axis }
   mu0*Mz00/2*[ z1/sqrt(z1^2+rm^2)- (z1-2*Lz)/sqrt((z1-2*Lz)^2+rm^2)]
   Mz=Bz/mu0-Hz
   mesh_spacing=0.1*Lz*(1+(r/Lz/0.001)^2+(z/Lz/3)^2)
EQUATIONS
   dz( Hr)- dr( Hz)=J_phi
BOUNDARIES
region 'domain'  J_phi=0  start(0,-L) value(A_phi)=0
   line to (2*L,-L) to (2*L,L)  to (0,L) close
region 'coil'  J_phi=Mz00/d           				{ Current density }
   start(r1,-Lz)  line to (r2,-Lz) to (r2,Lz) to (r1,Lz) close
PLOTS
   contour( Hz)  painted zoom(0,-3*Lz,  6*Lz,6*Lz)
   contour( Mz) painted zoom(0,-3*Lz,  6*Lz,6*Lz)
   contour( Bz) painted zoom(0,-3*Lz,  6*Lz,6*Lz)
   elevation( Bz, Bz_ex) from (0,-2*Lz) to (0,2*Lz)
   vector( H) norm zoom(0,-3*Lz,  6*Lz,6*Lz)
   vector( B) norm zoom(0,-3*Lz,  6*Lz,6*Lz)
   elevation( Hz) from (0,0) to (2*r2,0)
END

